class GenXrevenge expands Mutator config(GenXrevenge);

var config int	NumShotsForRevenge;

function ModifyPlayer(Pawn Other)
{
local RevengeItem RI;
local bool bFound;

	ForEach AllActors(class'RevengeItem', RI)
		{
		if ( RI.ItemOwner == Other )
			{
			bFound = True;
			}
		}
	if ( !bFound )
		{
		RI = Spawn(class'RevengeItem');
		RI.ItemOwner = Other;
		RI.LastKiller = None;
		RI.NumKills = 0;
		}


	if ( NextMutator != None )
		NextMutator.ModifyPlayer(Other);
}

function ScoreKill(pawn Killer, pawn Other)
{
local Inventory Inv;
local RevengeItem RI;

	Super.ScoreKill(Killer, Other);
	if ( Other != None )
		{
		if ( Killer == Other || killer == None ) //Suicide
			{
			for( Inv=Other.Inventory; Inv!=None; Inv=Inv.Inventory )
				{ 
				if ( Inv.IsA('RevengeItem') )
					{
					RevengeItem(Inv).LastKiller = None;
					RevengeItem(Inv).NumKills = 0;
					}
				}
			}
		else  //Regular kill
			{
			log(killer.PlayerReplicationInfo.PlayerName$" killed"@Other.PlayerReplicationInfo.PlayerName);
			for( Inv=Other.Inventory; Inv!=None; Inv=Inv.Inventory )
				{ 
				if ( Inv.IsA('RevengeItem') )
					{
					log("RevengeItem found, NumToBroadcast:"@NumShotsForRevenge);
					if ( RevengeItem(Inv).LastKiller == killer || RevengeItem(Inv).LastKiller == None )
						{
						RevengeItem(Inv).LastKiller = killer;
						RevengeItem(Inv).NumKills++;
						log("Killer is the same or None, Killer:"@RevengeItem(Inv).LastKiller.PlayerReplicationInfo.PlayerName$", NumKills:"@RevengeItem(Inv).NumKills);
						if ( RevengeItem(Inv).NumKills >= NumShotsForRevenge )
							{
							log("Revenge kill detected");
							Killer.ReceiveLocalizedMessage( class'RevengeMessage', 0, Killer.PlayerReplicationInfo, Other.PlayerReplicationInfo);
							RevengeItem(Inv).LastKiller = None;
							RevengeItem(Inv).NumKills = 0;
							}
						}
					}
				}
			}
		}

	if ( NextMutator != None )
		{
		NextMutator.ScoreKill(Killer, Other);
		}
}

defaultproperties
{
NumShotsForRevenge=5
}
